/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.asm;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class MethodTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if ("net.minecraftforge.fml.common.network.handshake.NetworkDispatcher$1".equals(transformedName)) {
            return this.patchNetworkDispatcher(basicClass);
        }
        if ("net.minecraft.entity.Entity".equals(transformedName)) {
            return this.patchEntity(basicClass);
        }
        if ("net.minecraft.entity.player.EntityPlayer".equals(transformedName)) {
            return this.patchEntityPlayer(basicClass);
        }
        if ("com.typesafe.config.impl.SimpleConfigOrigin".equals(transformedName)) {
            return this.patchSimpleConfigOrigin(basicClass);
        }
        if ("com.google.gson.internal.bind.TypeAdapters$EnumTypeAdapter".equals(transformedName)) {
            return this.patchTypeAdapters(basicClass);
        }
        return basicClass;
    }

    private byte[] patchNetworkDispatcher(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)classNode, 0);
        ClassWriter classWriter = new ClassWriter(1);
        MethodVisitor mv = classWriter.visitMethod(1, "sendPacket", "(Lnet/minecraft/network/Packet;)V", "(Lnet/minecraft/network/Packet<*>;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "net/minecraft/network/NetHandlerPlayServer", "func_147359_a", "(Lnet/minecraft/network/Packet;)V", true);
        mv.visitInsn(177);
        mv.visitEnd();
        classNode.access = 33;
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    private byte[] patchEntity(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)classNode, 0);
        ClassWriter classWriter = new ClassWriter(1);
        MethodVisitor mv = classWriter.visitMethod(1, "getUniqueID", "()Ljava/util/UUID;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "net/minecraft/entity/Entity", "func_110124_au", "()Ljava/util/UUID;", false);
        mv.visitInsn(176);
        mv.visitEnd();
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    private byte[] patchEntityPlayer(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)classNode, 0);
        ClassWriter classWriter = new ClassWriter(1);
        MethodVisitor mv = classWriter.visitMethod(1, "getProfile", "()Lcom/mojang/authlib/GameProfile;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "net/minecraft/entity/player/EntityPlayer", "func_146103_bH", "()Lcom/mojang/authlib/GameProfile;", false);
        mv.visitInsn(176);
        mv.visitEnd();
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    private byte[] patchSimpleConfigOrigin(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)classNode, 0);
        ClassWriter classWriter = new ClassWriter(1);
        MethodVisitor mv1 = classWriter.visitMethod(1, "setComments", "(Ljava/util/List;)Lcom/typesafe/config/impl/SimpleConfigOrigin;", "(Ljava/util/List<Ljava/lang/String;>;)Lcom/typesafe/config/impl/SimpleConfigOrigin;", null);
        mv1.visitCode();
        mv1.visitVarInsn(25, 0);
        mv1.visitVarInsn(25, 1);
        mv1.visitMethodInsn(182, "com/typesafe/config/impl/SimpleConfigOrigin", "withComments", "(Ljava/util/List;)Lcom/typesafe/config/impl/SimpleConfigOrigin;", false);
        mv1.visitInsn(176);
        mv1.visitEnd();
        MethodVisitor mv2 = classWriter.visitMethod(1, "setLineNumber", "(I)Lcom/typesafe/config/impl/SimpleConfigOrigin;", null, null);
        mv2.visitCode();
        mv2.visitVarInsn(25, 0);
        mv2.visitVarInsn(21, 1);
        mv2.visitMethodInsn(182, "com/typesafe/config/impl/SimpleConfigOrigin", "withLineNumber", "(I)Lcom/typesafe/config/impl/SimpleConfigOrigin;", false);
        mv2.visitInsn(176);
        mv2.visitEnd();
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    private byte[] patchTypeAdapters(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)classNode, 0);
        ClassWriter classWriter = new ClassWriter(1);
        for (MethodNode methodNode : classNode.methods) {
            if (!"<init>".equals(methodNode.name) || !"(Ljava/lang/Class;)V".equals(methodNode.desc)) continue;
            methodNode.instructions.clear();
            methodNode.tryCatchBlocks.clear();
            methodNode.localVariables.clear();
            methodNode.visitCode();
            methodNode.visitVarInsn(25, 0);
            methodNode.visitMethodInsn(183, "com/google/gson/TypeAdapter", "<init>", "()V", false);
            methodNode.visitVarInsn(25, 0);
            methodNode.visitTypeInsn(187, "java/util/HashMap");
            methodNode.visitInsn(89);
            methodNode.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
            methodNode.visitFieldInsn(181, "com/google/gson/internal/bind/TypeAdapters$EnumTypeAdapter", "nameToConstant", "Ljava/util/Map;");
            methodNode.visitVarInsn(25, 0);
            methodNode.visitTypeInsn(187, "java/util/HashMap");
            methodNode.visitInsn(89);
            methodNode.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
            methodNode.visitFieldInsn(181, "com/google/gson/internal/bind/TypeAdapters$EnumTypeAdapter", "constantToName", "Ljava/util/Map;");
            methodNode.visitVarInsn(25, 1);
            methodNode.visitVarInsn(25, 0);
            methodNode.visitFieldInsn(180, "com/google/gson/internal/bind/TypeAdapters$EnumTypeAdapter", "nameToConstant", "Ljava/util/Map;");
            methodNode.visitVarInsn(25, 0);
            methodNode.visitFieldInsn(180, "com/google/gson/internal/bind/TypeAdapters$EnumTypeAdapter", "constantToName", "Ljava/util/Map;");
            methodNode.visitMethodInsn(184, "catserver/server/asm/MethodHook", "TypeAdapters$EnumTypeAdapter_Init", "(Ljava/lang/Class;Ljava/util/Map;Ljava/util/Map;)V", false);
            methodNode.visitInsn(177);
            methodNode.visitEnd();
            break;
        }
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }
}

